////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

/**
 * Available protection types for generating one-time passwords and signatures.
 */
NS_REFINED_FOR_SWIFT
typedef enum {

/**
 * No password is needed for generating one-time passwords and signatures.
 */
            ProtectionTypeNoPassword = 1,
/**
 * A password is needed for generating one-time passwords and signatures.
 */
            ProtectionTypePassword,
/**
 * A biometric scan is needed for generating one-time passwords and signatures.
 */
            ProtectionTypeBiometric,

} ProtectionType;
